#
# The Python Imaging Library.
# $Id: PpmImagePlugin.py,v 1.4 1996/05/09 21:21:53 fredrik Exp fredrik $
#
# IM Tools support for PIL
#
# history:
#	96-05-27 fl	Created (read 8-bit images only)
#
# Copyright (c) Fredrik Lundh 1996.  All rights reserved.
#
# See the README file for information on usage and redistribution.
#


__version__ = "0.1"

import regex, string

import Image, ImageFile

#
# --------------------------------------------------------------------

field = regex.compile("\([a-z]*\) \([^ \r\n]*\)")

class ImtImageFile(ImageFile.ImageFile):

    format = "IMT"
    format_description = "IM Tools"

    def _open(self):

	# Quick rejection: if there's not a LF among the first
	# 100 bytes, this is (probably) not a text header.

	if not "\n" in self.fp.read(100):
	    raise SyntaxError, "not an IM file"
	self.fp.seek(0)

	xsize = ysize = 0

	while 1:

	    s = self.fp.read(1)
	    if not s:
		break

	    if s == chr(12):

		# image data begins
	        self.tile = [("raw", (0,0)+self.size,
			     self.fp.tell(),
		             (self.mode, 0, 1))]

		break

	    else:

		# read key/value pair
		# FIXME: dangerous, may read whole file
		s = s + self.fp.readline()
		if len(s) == 1 or len(s) > 100:
		    break
		if s[0] == "*":
		    continue # comment

		if field.match(s) < 0:
		    break
		k, v = field.group(1,2)
		if k == "width":
		    xsize = string.atoi(v)
		    self.size = xsize, ysize
		elif k == "height":
		    ysize = string.atoi(v)
		    self.size = xsize, ysize
		elif k == "pixel" and v == "n8":
		    self.mode = "L"
		    

#
# --------------------------------------------------------------------

Image.register_open("IMT", ImtImageFile)

#
# no extension registered (".im" is simply too common)
