////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:13
//  it declares the content of the module _Controls
////

unit Python_Controls;

interface

uses
   Windows,
   Graphics,
   Menus,
   Controls,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_Controls = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TDragObject_ReadAttribute( Self : TDragObject; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TDragObject_WriteAttribute( Self : TDragObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TDragControlObject_ReadAttribute( Self : TDragControlObject; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TDragControlObject_WriteAttribute( Self : TDragControlObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TControlCanvas_ReadAttribute( Self : TControlCanvas; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TControlCanvas_WriteAttribute( Self : TControlCanvas; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TControl_ReadAttribute( Self : TControl; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TControl_WriteAttribute( Self : TControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TWinControl_ReadAttribute( Self : TWinControl; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TWinControl_WriteAttribute( Self : TWinControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TGraphicControl_ReadAttribute( Self : TGraphicControl; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TGraphicControl_WriteAttribute( Self : TGraphicControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomControl_ReadAttribute( Self : TCustomControl; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomControl_WriteAttribute( Self : TCustomControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function THintWindow_ReadAttribute( Self : THintWindow; argSelf : PPyObject; key : PChar ) : PPyObject;
  function THintWindow_WriteAttribute( Self : THintWindow; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TChangeLink_ReadAttribute( Self : TChangeLink; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TChangeLink_WriteAttribute( Self : TChangeLink; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TCustomImageList_ReadAttribute( Self : TCustomImageList; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TCustomImageList_WriteAttribute( Self : TCustomImageList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TImageList_ReadAttribute( Self : TImageList; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TImageList_WriteAttribute( Self : TImageList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_Classes,
   Python_Classes,
   Delphi_Graphics,
   Python_Graphics,
   Delphi_Menus,
   Python_Menus,
   Delphi_System,
   Delphi_Controls,
   Python_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gControls : TModule_Controls;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gControls := TModule_Controls.Create( AOwner );
  with gControls do
    begin
      Engine := AEngine;
      ModuleName := '_Controls';
    end;
end;

///////////// Functions for class TDragObject //////////////////

function TDragObject_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyDragObject;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TDragObject.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyDragObject.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TDragObject_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDragObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDragObject) then begin
      ErrorWrongExpectedType( argSelf, 'TDragObject' );
      Exit;
    end;
    realObj := TDragObject(obj);
    // Check attribute
    Result := TDragObject_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TDragObject_ReadAttribute( Self : TDragObject; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TDragObject_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDragObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDragObject) then begin
      ErrorWrongExpectedType( argSelf, 'TDragObject' );
      Exit;
    end;
    realObj := TDragObject(obj);
    // Check attribute
    Result := TDragObject_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TDragObject_WriteAttribute( Self : TDragObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TDragControlObject //////////////////

function TDragControlObject_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyDragControlObject;
  argSelf : PPyObject;
  argAControl : PPyObject;
  objAControl : TControl;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TDragControlObject.Create', [ @argSelf,
                  @argAControl       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAControl := GetObjectOf( argAControl ) as TControl;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyDragControlObject.Create( objAControl );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TDragControlObject_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDragControlObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDragControlObject) then begin
      ErrorWrongExpectedType( argSelf, 'TDragControlObject' );
      Exit;
    end;
    realObj := TDragControlObject(obj);
    // Check attribute
    Result := TDragControlObject_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TDragControlObject_ReadAttribute( Self : TDragControlObject; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Control' ) = 0 then Result := GetPythonObject( Self.Control, 'Controls', 'TControl' )
    else Result := TDragObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TDragControlObject_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TDragControlObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TDragControlObject) then begin
      ErrorWrongExpectedType( argSelf, 'TDragControlObject' );
      Exit;
    end;
    realObj := TDragControlObject(obj);
    // Check attribute
    Result := TDragControlObject_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TDragControlObject_WriteAttribute( Self : TDragControlObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Control' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TDragObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TControlCanvas //////////////////

function TControlCanvas_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyControlCanvas;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TControlCanvas.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyControlCanvas.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TControlCanvas_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TControlCanvas;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TControlCanvas) then begin
      ErrorWrongExpectedType( argSelf, 'TControlCanvas' );
      Exit;
    end;
    realObj := TControlCanvas(obj);
    // Check attribute
    Result := TControlCanvas_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TControlCanvas_ReadAttribute( Self : TControlCanvas; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Control' ) = 0 then Result := GetPythonObject( Self.Control, 'Controls', 'TControl' )
    else Result := TCanvas_ReadAttribute( Self, argSelf, key );
  end;
end;

function TControlCanvas_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TControlCanvas;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TControlCanvas) then begin
      ErrorWrongExpectedType( argSelf, 'TControlCanvas' );
      Exit;
    end;
    realObj := TControlCanvas(obj);
    // Check attribute
    Result := TControlCanvas_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TControlCanvas_WriteAttribute( Self : TControlCanvas; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Control' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TControl then begin
        Self.Control := TControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Control', 'TControl' );
    end else Result := TCanvas_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TControl //////////////////

function TControl_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyControl;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TControl.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyControl.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TControl_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TControl) then begin
      ErrorWrongExpectedType( argSelf, 'TControl' );
      Exit;
    end;
    realObj := TControl(obj);
    // Check attribute
    Result := TControl_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TControl_ReadAttribute( Self : TControl; argSelf : PPyObject; key : PChar ) : PPyObject;
var
  tmpControlState : TControlState;
  tmpControlStyle : TControlStyle;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Align' ) = 0 then Result := VariantAsPyObject( Integer( Self.Align ) )
    else if CompareText( key, 'BoundsRect' ) = 0 then Result := CreateRect( Self.BoundsRect ).GetSelf
    else if CompareText( key, 'ClientHeight' ) = 0 then Result := VariantAsPyObject( Self.ClientHeight )
    else if CompareText( key, 'ClientOrigin' ) = 0 then Result := CreatePoint( Self.ClientOrigin ).GetSelf
    else if CompareText( key, 'ClientRect' ) = 0 then Result := CreateRect( Self.ClientRect ).GetSelf
    else if CompareText( key, 'ClientWidth' ) = 0 then Result := VariantAsPyObject( Self.ClientWidth )
    else if CompareText( key, 'ControlState' ) = 0 then begin
      tmpControlState := Self.ControlState;
      Result := SetToList( @tmpControlState, sizeof(tmpControlState) )
    end
    else if CompareText( key, 'ControlStyle' ) = 0 then begin
      tmpControlStyle := Self.ControlStyle;
      Result := SetToList( @tmpControlStyle, sizeof(tmpControlStyle) )
    end
    else if CompareText( key, 'Parent' ) = 0 then Result := GetPythonObject( Self.Parent, 'Controls', 'TWinControl' )
    else if CompareText( key, 'ShowHint' ) = 0 then Result := VariantAsPyObject( Self.ShowHint )
    else if CompareText( key, 'Visible' ) = 0 then Result := VariantAsPyObject( Self.Visible )
    else if CompareText( key, 'Enabled' ) = 0 then Result := VariantAsPyObject( Self.Enabled )
    else if CompareText( key, 'WindowProc' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TWndMethod' ); Result := nil; end
    else if CompareText( key, 'Left' ) = 0 then Result := VariantAsPyObject( Self.Left )
    else if CompareText( key, 'Top' ) = 0 then Result := VariantAsPyObject( Self.Top )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'Cursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.Cursor ) )
    else if CompareText( key, 'Hint' ) = 0 then Result := VariantAsPyObject( Self.Hint )
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TControl_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TControl) then begin
      ErrorWrongExpectedType( argSelf, 'TControl' );
      Exit;
    end;
    realObj := TControl(obj);
    // Check attribute
    Result := TControl_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TControl_WriteAttribute( Self : TControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
  tmpControlState : TControlState;
  tmpControlStyle : TControlStyle;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Align' ) = 0 then begin
      Self.Align := TAlign(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BoundsRect' ) = 0 then begin
      Self.BoundsRect := PyObjectAsRect( Value );      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ClientHeight' ) = 0 then begin
      Self.ClientHeight := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ClientOrigin' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ClientRect' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ClientWidth' ) = 0 then begin
      Self.ClientWidth := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ControlState' ) = 0 then begin
      if PyList_Check(value) then begin
        ListToSet( value, @tmpControlState, sizeof(tmpControlState) );
        Self.ControlState := tmpControlState;
        Result := PyInt_FromLong(0);
      end else
        ErrorWrongSetPropertyType( argSelf, 'ControlState', 'TControlState' );
    end else if CompareText( key, 'ControlStyle' ) = 0 then begin
      if PyList_Check(value) then begin
        ListToSet( value, @tmpControlStyle, sizeof(tmpControlStyle) );
        Self.ControlStyle := tmpControlStyle;
        Result := PyInt_FromLong(0);
      end else
        ErrorWrongSetPropertyType( argSelf, 'ControlStyle', 'TControlStyle' );
    end else if CompareText( key, 'Parent' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TWinControl then begin
        Self.Parent := TWinControl( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Parent', 'TWinControl' );
    end else if CompareText( key, 'ShowHint' ) = 0 then begin
      Self.ShowHint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Visible' ) = 0 then begin
      Self.Visible := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Enabled' ) = 0 then begin
      Self.Enabled := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'WindowProc' ) = 0 then begin
      if Value = Py_None then begin
        Self.WindowProc := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyControl then
          with TPyControl(Self) do
            WindowProc := EventWindowProc;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'Left' ) = 0 then begin
      Self.Left := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Top' ) = 0 then begin
      Self.Top := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Width' ) = 0 then begin
      Self.Width := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Height' ) = 0 then begin
      Self.Height := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Cursor' ) = 0 then begin
      Self.Cursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Hint' ) = 0 then begin
      Self.Hint := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TWinControl //////////////////

function TWinControl_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyWinControl;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TWinControl.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyWinControl.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TWinControl_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyWinControl;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TWinControl.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyWinControl.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TWinControl_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TWinControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TWinControl) then begin
      ErrorWrongExpectedType( argSelf, 'TWinControl' );
      Exit;
    end;
    realObj := TWinControl(obj);
    // Check attribute
    Result := TWinControl_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TWinControl_ReadAttribute( Self : TWinControl; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Brush' ) = 0 then Result := GetPythonObject( Self.Brush, 'Controls', 'TBrush' )
    else if CompareText( key, 'ControlCount' ) = 0 then Result := VariantAsPyObject( Self.ControlCount )
    else if CompareText( key, 'Handle' ) = 0 then Result := VariantAsPyObject( Self.Handle )
    else if CompareText( key, 'ParentWindow' ) = 0 then Result := VariantAsPyObject( Self.ParentWindow )
    else if CompareText( key, 'Showing' ) = 0 then Result := VariantAsPyObject( Self.Showing )
    else if CompareText( key, 'TabOrder' ) = 0 then Result := VariantAsPyObject( Integer( Self.TabOrder ) )
    else if CompareText( key, 'TabStop' ) = 0 then Result := VariantAsPyObject( Self.TabStop )
    else if CompareText( key, 'HelpContext' ) = 0 then Result := VariantAsPyObject( Integer( Self.HelpContext ) )
    else Result := TControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TWinControl_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TWinControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TWinControl) then begin
      ErrorWrongExpectedType( argSelf, 'TWinControl' );
      Exit;
    end;
    realObj := TWinControl(obj);
    // Check attribute
    Result := TWinControl_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TWinControl_WriteAttribute( Self : TWinControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Brush' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ControlCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'ParentWindow' ) = 0 then begin
      Self.ParentWindow := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Showing' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'TabOrder' ) = 0 then begin
      Self.TabOrder := TTabOrder(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'TabStop' ) = 0 then begin
      Self.TabStop := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'HelpContext' ) = 0 then begin
      Self.HelpContext := THelpContext(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else Result := TControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TGraphicControl //////////////////

function TGraphicControl_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyGraphicControl;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TGraphicControl.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyGraphicControl.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TGraphicControl_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGraphicControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGraphicControl) then begin
      ErrorWrongExpectedType( argSelf, 'TGraphicControl' );
      Exit;
    end;
    realObj := TGraphicControl(obj);
    // Check attribute
    Result := TGraphicControl_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TGraphicControl_ReadAttribute( Self : TGraphicControl; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TGraphicControl_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TGraphicControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TGraphicControl) then begin
      ErrorWrongExpectedType( argSelf, 'TGraphicControl' );
      Exit;
    end;
    realObj := TGraphicControl(obj);
    // Check attribute
    Result := TGraphicControl_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TGraphicControl_WriteAttribute( Self : TGraphicControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomControl //////////////////

function TCustomControl_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomControl;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomControl.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomControl.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomControl_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomControl;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:TCustomControl.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomControl.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomControl_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomControl) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomControl' );
      Exit;
    end;
    realObj := TCustomControl(obj);
    // Check attribute
    Result := TCustomControl_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomControl_ReadAttribute( Self : TCustomControl; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := TWinControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomControl_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomControl;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomControl) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomControl' );
      Exit;
    end;
    realObj := TCustomControl(obj);
    // Check attribute
    Result := TCustomControl_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomControl_WriteAttribute( Self : TCustomControl; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else Result := TWinControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class THintWindow //////////////////

function THintWindow_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyHintWindow;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:THintWindow.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyHintWindow.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function THintWindow_CreateParented( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyHintWindow;
  argSelf : PPyObject;
  argParentWindow : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oi:THintWindow.CreateParented', [ @argSelf,
                  @argParentWindow       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyHintWindow.CreateParented( HWnd(argParentWindow) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function THintWindow_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : THintWindow;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is THintWindow) then begin
      ErrorWrongExpectedType( argSelf, 'THintWindow' );
      Exit;
    end;
    realObj := THintWindow(obj);
    // Check attribute
    Result := THintWindow_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function THintWindow_ReadAttribute( Self : THintWindow; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Caption' ) = 0 then Result := VariantAsPyObject( Self.Caption )
    else if CompareText( key, 'Color' ) = 0 then Result := VariantAsPyObject( Integer( Self.Color ) )
    else if CompareText( key, 'Canvas' ) = 0 then Result := GetPythonObject( Self.Canvas, 'Controls', 'TCanvas' )
    else Result := TCustomControl_ReadAttribute( Self, argSelf, key );
  end;
end;

function THintWindow_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : THintWindow;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is THintWindow) then begin
      ErrorWrongExpectedType( argSelf, 'THintWindow' );
      Exit;
    end;
    realObj := THintWindow(obj);
    // Check attribute
    Result := THintWindow_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function THintWindow_WriteAttribute( Self : THintWindow; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Caption' ) = 0 then begin
      Self.Caption := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Color' ) = 0 then begin
      Self.Color := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Canvas' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TCustomControl_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TChangeLink //////////////////

function TChangeLink_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyChangeLink;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TChangeLink.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyChangeLink.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TChangeLink_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TChangeLink;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TChangeLink) then begin
      ErrorWrongExpectedType( argSelf, 'TChangeLink' );
      Exit;
    end;
    realObj := TChangeLink(obj);
    // Check attribute
    Result := TChangeLink_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TChangeLink_ReadAttribute( Self : TChangeLink; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'Sender' ) = 0 then Result := GetPythonObject( Self.Sender, 'Controls', 'TCustomImageList' )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TChangeLink_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TChangeLink;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TChangeLink) then begin
      ErrorWrongExpectedType( argSelf, 'TChangeLink' );
      Exit;
    end;
    realObj := TChangeLink(obj);
    // Check attribute
    Result := TChangeLink_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TChangeLink_WriteAttribute( Self : TChangeLink; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyChangeLink then
          with TPyChangeLink(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'Sender' ) = 0 then begin
      obj := GetObjectOf(value);
      if obj is TCustomImageList then begin
        Self.Sender := TCustomImageList( obj );
        Result := PyInt_FromLong(0);
      end else ErrorWrongPropertyType( argSelf, obj, 'Sender', 'TCustomImageList' );
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TCustomImageList //////////////////

function TCustomImageList_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomImageList;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TCustomImageList.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomImageList.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomImageList_CreateSize( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyCustomImageList;
  argSelf : PPyObject;
  argAWidth : Integer;
  argAHeight : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oii:TCustomImageList.CreateSize', [ @argSelf,
                  @argAWidth,
                  @argAHeight       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyCustomImageList.CreateSize( Integer(argAWidth), Integer(argAHeight) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TCustomImageList_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomImageList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomImageList) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomImageList' );
      Exit;
    end;
    realObj := TCustomImageList(obj);
    // Check attribute
    Result := TCustomImageList_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TCustomImageList_ReadAttribute( Self : TCustomImageList; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'Count' ) = 0 then Result := VariantAsPyObject( Self.Count )
    else if CompareText( key, 'DragCursor' ) = 0 then Result := VariantAsPyObject( Integer( Self.DragCursor ) )
    else if CompareText( key, 'Dragging' ) = 0 then Result := VariantAsPyObject( Self.Dragging )
    else if CompareText( key, 'Handle' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'HImageList' ); Result := nil; end
    else Result := TComponent_ReadAttribute( Self, argSelf, key );
  end;
end;

function TCustomImageList_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TCustomImageList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TCustomImageList) then begin
      ErrorWrongExpectedType( argSelf, 'TCustomImageList' );
      Exit;
    end;
    realObj := TCustomImageList(obj);
    // Check attribute
    Result := TCustomImageList_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TCustomImageList_WriteAttribute( Self : TCustomImageList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'Count' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'DragCursor' ) = 0 then begin
      Self.DragCursor := TCursor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Dragging' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else if CompareText( key, 'Handle' ) = 0 then begin
      ErrorTypeNotHandled( argSelf, key, 'HImageList' );
    end else Result := TComponent_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Functions for class TImageList //////////////////

function TImageList_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyImageList;
  argSelf : PPyObject;
  argAOwner : PPyObject;
  objAOwner : TComponent;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'OO:TImageList.Create', [ @argSelf,
                  @argAOwner       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    objAOwner := GetObjectOf( argAOwner ) as TComponent;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyImageList.Create( objAOwner );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TImageList_CreateSize( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyImageList;
  argSelf : PPyObject;
  argAWidth : Integer;
  argAHeight : Integer;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'Oii:TImageList.CreateSize', [ @argSelf,
                  @argAWidth,
                  @argAHeight       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyImageList.CreateSize( Integer(argAWidth), Integer(argAHeight) );
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TImageList_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TImageList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TImageList) then begin
      ErrorWrongExpectedType( argSelf, 'TImageList' );
      Exit;
    end;
    realObj := TImageList(obj);
    // Check attribute
    Result := TImageList_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TImageList_ReadAttribute( Self : TImageList; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'BlendColor' ) = 0 then Result := VariantAsPyObject( Integer( Self.BlendColor ) )
    else if CompareText( key, 'BkColor' ) = 0 then Result := VariantAsPyObject( Integer( Self.BkColor ) )
    else if CompareText( key, 'AllocBy' ) = 0 then Result := VariantAsPyObject( Self.AllocBy )
    else if CompareText( key, 'DrawingStyle' ) = 0 then Result := VariantAsPyObject( Integer( Self.DrawingStyle ) )
    else if CompareText( key, 'Height' ) = 0 then Result := VariantAsPyObject( Self.Height )
    else if CompareText( key, 'ImageType' ) = 0 then Result := VariantAsPyObject( Integer( Self.ImageType ) )
    else if CompareText( key, 'Masked' ) = 0 then Result := VariantAsPyObject( Self.Masked )
    else if CompareText( key, 'OnChange' ) = 0 then begin ErrorTypeNotHandled( argSelf, key, 'TNotifyEvent' ); Result := nil; end
    else if CompareText( key, 'ShareImages' ) = 0 then Result := VariantAsPyObject( Self.ShareImages )
    else if CompareText( key, 'Width' ) = 0 then Result := VariantAsPyObject( Self.Width )
    else Result := TCustomImageList_ReadAttribute( Self, argSelf, key );
  end;
end;

function TImageList_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TImageList;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TImageList) then begin
      ErrorWrongExpectedType( argSelf, 'TImageList' );
      Exit;
    end;
    realObj := TImageList(obj);
    // Check attribute
    Result := TImageList_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TImageList_WriteAttribute( Self : TImageList; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'BlendColor' ) = 0 then begin
      Self.BlendColor := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'BkColor' ) = 0 then begin
      Self.BkColor := TColor(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'AllocBy' ) = 0 then begin
      Self.AllocBy := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'DrawingStyle' ) = 0 then begin
      Self.DrawingStyle := TDrawingStyle(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Height' ) = 0 then begin
      Self.Height := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'ImageType' ) = 0 then begin
      Self.ImageType := TImageType(PyObjectAsVariant( value ));
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Masked' ) = 0 then begin
      Self.Masked := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'OnChange' ) = 0 then begin
      if Value = Py_None then begin
        Self.OnChange := nil;
        Result := AddNewMember( argSelf, key, value );
      end else if CheckMethod( Value ) then begin
        if Self is TPyImageList then
          with TPyImageList(Self) do
            OnChange := EventOnChange;
        Result := AddNewMember( argSelf, key, value );
      end else ErrorBadEventType( argSelf, key );
    end else if CompareText( key, 'ShareImages' ) = 0 then begin
      Self.ShareImages := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else if CompareText( key, 'Width' ) = 0 then begin
      Self.Width := PyObjectAsVariant( value );
      Result := PyInt_FromLong(0);
    end else Result := TCustomImageList_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_Controls.Initialize;
begin
  AddMethod( 'CreateDragObject', TDragObject_Create, '' );
  AddMethod( 'DragObject_GetAttr', TDragObject_GetAttr, '' );
  AddMethod( 'DragObject_SetAttr', TDragObject_SetAttr, '' );
  AddMethod( 'CreateDragControlObject', TDragControlObject_Create, '' );
  AddMethod( 'DragControlObject_GetAttr', TDragControlObject_GetAttr, '' );
  AddMethod( 'DragControlObject_SetAttr', TDragControlObject_SetAttr, '' );
  AddMethod( 'CreateControlCanvas', TControlCanvas_Create, '' );
  AddMethod( 'ControlCanvas_GetAttr', TControlCanvas_GetAttr, '' );
  AddMethod( 'ControlCanvas_SetAttr', TControlCanvas_SetAttr, '' );
  AddMethod( 'CreateControl', TControl_Create, '' );
  AddMethod( 'Control_GetAttr', TControl_GetAttr, '' );
  AddMethod( 'Control_SetAttr', TControl_SetAttr, '' );
  AddMethod( 'CreateWinControl', TWinControl_Create, '' );
  AddMethod( 'CreateParentedWinControl', TWinControl_CreateParented, '' );
  AddMethod( 'WinControl_GetAttr', TWinControl_GetAttr, '' );
  AddMethod( 'WinControl_SetAttr', TWinControl_SetAttr, '' );
  AddMethod( 'CreateGraphicControl', TGraphicControl_Create, '' );
  AddMethod( 'GraphicControl_GetAttr', TGraphicControl_GetAttr, '' );
  AddMethod( 'GraphicControl_SetAttr', TGraphicControl_SetAttr, '' );
  AddMethod( 'CreateCustomControl', TCustomControl_Create, '' );
  AddMethod( 'CreateParentedCustomControl', TCustomControl_CreateParented, '' );
  AddMethod( 'CustomControl_GetAttr', TCustomControl_GetAttr, '' );
  AddMethod( 'CustomControl_SetAttr', TCustomControl_SetAttr, '' );
  AddMethod( 'CreateHintWindow', THintWindow_Create, '' );
  AddMethod( 'CreateParentedHintWindow', THintWindow_CreateParented, '' );
  AddMethod( 'HintWindow_GetAttr', THintWindow_GetAttr, '' );
  AddMethod( 'HintWindow_SetAttr', THintWindow_SetAttr, '' );
  AddMethod( 'CreateChangeLink', TChangeLink_Create, '' );
  AddMethod( 'ChangeLink_GetAttr', TChangeLink_GetAttr, '' );
  AddMethod( 'ChangeLink_SetAttr', TChangeLink_SetAttr, '' );
  AddMethod( 'CreateCustomImageList', TCustomImageList_Create, '' );
  AddMethod( 'CreateSizeCustomImageList', TCustomImageList_CreateSize, '' );
  AddMethod( 'CustomImageList_GetAttr', TCustomImageList_GetAttr, '' );
  AddMethod( 'CustomImageList_SetAttr', TCustomImageList_SetAttr, '' );
  AddMethod( 'CreateImageList', TImageList_Create, '' );
  AddMethod( 'CreateSizeImageList', TImageList_CreateSize, '' );
  AddMethod( 'ImageList_GetAttr', TImageList_GetAttr, '' );
  AddMethod( 'ImageList_SetAttr', TImageList_SetAttr, '' );
  inherited;
end;

end.
