////
//  This file was generated by VCL Generator
//  Copyright 1998 - Morgan Martinet
//  07/04/98 17:26:21
//  it declares the content of the module _System
////

unit Python_System;

interface

uses
   Windows,
   Classes,
   SysUtils,
   PythonEngine;

type
  TModule_System = class( TPythonModule )
  public
    procedure Initialize; override;
  end;

  function TObject_ReadAttribute( Self : TObject; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TObject_WriteAttribute( Self : TObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
  function TInterfacedObject_ReadAttribute( Self : TInterfacedObject; argSelf : PPyObject; key : PChar ) : PPyObject;
  function TInterfacedObject_WriteAttribute( Self : TInterfacedObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;

  procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 

implementation

uses
   Delphi_System,
   Py_Misc,
   PyRecords,
   PyDelphiAssoc;

var
  IsInitialized : Boolean;
  gSystem : TModule_System;
procedure Init( AOwner : TComponent; AEngine : TPythonEngine ); 
begin
  if IsInitialized then
    Exit;
  IsInitialized := True;
  gSystem := TModule_System.Create( AOwner );
  with gSystem do
    begin
      Engine := AEngine;
      ModuleName := '_System';
    end;
end;

///////////// Functions for class TObject //////////////////

function TObject_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyObject;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TObject.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyObject.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TObject_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TObject) then begin
      ErrorWrongExpectedType( argSelf, 'TObject' );
      Exit;
    end;
    realObj := TObject(obj);
    // Check attribute
    Result := TObject_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TObject_ReadAttribute( Self : TObject; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else Result := nil;
  end;
end;

function TObject_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TObject) then begin
      ErrorWrongExpectedType( argSelf, 'TObject' );
      Exit;
    end;
    realObj := TObject(obj);
    // Check attribute
    Result := TObject_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TObject_WriteAttribute( Self : TObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end;
  end;
end;

///////////// Functions for class TInterfacedObject //////////////////

function TInterfacedObject_Create( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  newObj : TPyInterfacedObject;
  argSelf : PPyObject;
begin
  with GetPythonEngine do begin
    if PyArg_ParseTuple( Args, 'O:TInterfacedObject.Create', [ @argSelf       ] ) = 0 then
      begin
        Result := nil;
        Exit;
      end;
    if PyErr_Occurred <> nil then
      begin
        Result := nil;
        Exit;
      end;
    newObj := TPyInterfacedObject.Create;
    DefInterfaceObject( newObj, argSelf, True );
    Result := argSelf;
    Py_XIncRef( Result );
  end;
end;

function TInterfacedObject_GetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TInterfacedObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'Os', [@argSelf, @argKey]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TInterfacedObject) then begin
      ErrorWrongExpectedType( argSelf, 'TInterfacedObject' );
      Exit;
    end;
    realObj := TInterfacedObject(obj);
    // Check attribute
    Result := TInterfacedObject_ReadAttribute( realObj, argSelf, argKey );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      UnknownProperty( argSelf, argKey );
  end;
end;

function TInterfacedObject_ReadAttribute( Self : TInterfacedObject; argSelf : PPyObject; key : PChar ) : PPyObject;
begin
  with GetPythonEngine do begin
    if CompareText( key, 'Properties') = 0 then Result := GetPropList( Self )
    else if CompareText( key, 'RefCount' ) = 0 then Result := VariantAsPyObject( Self.RefCount )
    else Result := TObject_ReadAttribute( Self, argSelf, key );
  end;
end;

function TInterfacedObject_SetAttr( Self, Args : PPyObject ) : PPyObject; cdecl; far;
var
  argSelf, argValue : PPyObject;
  argKey : PChar;
  obj : TObject;
  realObj : TInterfacedObject;
begin
  Result := nil;
  with GetPythonEngine do begin
    // Extract args
    if PyArg_ParseTuple( Args, 'OsO', [@argSelf, @argKey, @argValue]) = 0 then
      Exit;
    // Check Delphi object
    obj := GetObjectOf( argSelf );
    if not Assigned(obj) then begin
      ErrorNoObject( argSelf );
      Exit;
    end;
    // Check object type
    if not( obj is TInterfacedObject) then begin
      ErrorWrongExpectedType( argSelf, 'TInterfacedObject' );
      Exit;
    end;
    realObj := TInterfacedObject(obj);
    // Check attribute
    Result := TInterfacedObject_WriteAttribute( realObj, argSelf, argKey, argValue );
    // Check result
    if not Assigned(Result) and (PyErr_Occurred = nil) then
      Result := AddNewMember( argSelf, argKey, argValue );
  end;
end;

function TInterfacedObject_WriteAttribute( Self : TInterfacedObject; argSelf : PPyObject; key : PChar; value : PPyObject ) : PPyObject;
var
  obj : TObject;
begin
  Result := nil;
  obj := nil;
  with GetPythonEngine do begin
    if False then begin
    end else if CompareText( key, 'RefCount' ) = 0 then begin
      ErrorPropReadOnly( argSelf, key );
    end else Result := TObject_WriteAttribute( Self, argSelf, key, value );
  end;
end;

///////////// Initialization of the module ///////////

procedure TModule_System.Initialize;
begin
  AddMethod( 'CreateObject', TObject_Create, '' );
  AddMethod( 'Object_GetAttr', TObject_GetAttr, '' );
  AddMethod( 'Object_SetAttr', TObject_SetAttr, '' );
  AddMethod( 'CreateInterfacedObject', TInterfacedObject_Create, '' );
  AddMethod( 'InterfacedObject_GetAttr', TInterfacedObject_GetAttr, '' );
  AddMethod( 'InterfacedObject_SetAttr', TInterfacedObject_SetAttr, '' );
  inherited;
end;

end.
