(**************************************************************************)
(*                                                                        *)
(* Module:  Program 'TestPyt'          Copyright (c) 1997                 *)
(* Version: 1.0                        IBS Schillings GmbH & Co KG        *)
(* Sub-Version: 0.4                    Ein Unternehmen der KROHNE-Gruppe  *)
(*                                     Heisenbergstr. 18                  *)
(*                                     50169 Kerpen-Trnich               *)
(*                                     Phone: (49)22 37/97 44-0           *)
(*                                                                        *)
(**************************************************************************)
(*  Functionality:  Tests DelphPyt Component                              *)
(*  Changes: 1.4 Further Functionality, eliminated German Words           *)
(*                                                                        *)
(*  		                                                          *)
(*  Dr. Dietmar Budelsky 1997		                                  *)
(*  budelsky@ibs.bm.eunet.de                                              *)
(*                                                                        *)
(**************************************************************************)
(* This source code is distributed with no WARRANTY, for no reason or use.*)
(* Everyone is allowed to use and change this code free for his own tasks *)
(* and projects, as long as this header and its copyright text is intact. *)
(* For changed versions of this code, which are public distributed the    *)
(* following additional conditions have to be fullfilled:                 *)
(* 1) The header has to contain a comment on the change and the author of *)
(*    it.                                                                 *)
(* 2) A copy of the changed source has to be sent to the above E-Mail     *)
(*    address or my then valid address, if this is possible to the        *)
(*    author.                                                             *)
(* The second condition has the target to maintain an up to date central  *)
(* version of the component. If this condition is not acceptable for      *)
(* confidential or legal reasons, everyone is free to derive a component  *)
(* or to generate a diff file to my or other original sources.            *)
(* Dr. Dietmar Budelsky, 1997-11-12                                       *)
(**************************************************************************)
unit Pytform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, DelphPYT, Dialogs;


type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    RunButton: TBitBtn;
    CloseButton: TBitBtn;
    PytRun1: TPytRun;
    LoadButton: TBitBtn;
    SaveButton: TBitBtn;
    LoadDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    EvalButton: TBitBtn;
    procedure RunButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure EvalButtonClick(Sender: TObject);
  private
      pdict:     PPyObject;
      filename: TFileName;
      procedure run_memo_script(mode: Integer);
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

function NEW_Debug ( self, args:PPyObject): PPyObject; cdecl;
function NEW_Output( self, args:PPyObject): PPyObject; cdecl;
function NEW_Print( self, args:PPyObject): PPyObject; cdecl;
function NEW_TestIO( self, args:PPyObject): PPyObject; cdecl;

implementation
{$R *.DFM}


procedure TForm1.run_memo_script(mode: Integer);
var
  NewCount,i:       Integer;
  pval:             PPyObject;
  StrObj :          PPyObject;
  text: PChar;

begin
 NewCount := Memo1.Lines.Count;
 with PytRun1 do begin
   clearscript;
   for i := 0 to NewCount - 1 do
       addscript(Memo1.Lines.Strings[i]);
   if NewCount <> 0 then begin
      pval := PyRun_String(getscript, mode, pdict, pdict);
      if pval = nil then begin
         Memo2.Lines.Add(GetPytError);
      end else begin
         if mode = eval_input then begin
           StrObj := PyObject_Str(pval);
           text := PyString_AsString(StrObj);
           Form1.Memo2.Lines.Add(text);
           Py_XDECREF(StrObj);
         end;
         Py_DECREF(pval);
      end;
   end;
 end;
end;

procedure TForm1.RunButtonClick(Sender: TObject);
begin
  run_memo_script(file_input);
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  PytRun1.destroy;
  Application.Terminate;
end;


function NEW_Debug ( self, args:PPyObject): PPyObject; cdecl;
begin
  with GetPytDLL(self) do begin
    Py_INCREF(Py_None);
    NEW_Debug := Py_None;
  end;
end;

function NEW_Print( self, args:PPyObject): PPyObject; cdecl;
var
  TempObj,StrObj : PPyObject;
  linetext, cr: PChar;
begin
  with GetPytDLL(self) do begin
    if PyArg_ParseTuple(args,'O',[@TempObj]) <> 0 then begin
       StrObj := PyObject_Str(TempObj);
       linetext := PyString_AsString(StrObj);

       with Form1.Memo2.Lines do repeat
         cr := StrScan(linetext,#10);
         if cr <> nil then begin
           Strings[Count-1] := Strings[Count-1]+Copy(linetext,1,cr-linetext);
           linetext := cr+1;
           Add('');
         end else
           Strings[Count-1] := Strings[Count-1]+linetext;
       until cr = nil;

       Py_XDECREF(StrObj);
       Py_INCREF(Py_None);
       NEW_Print := Py_None;
    end else begin
       PyErr_SetString(GetErrorObject(self), 'Wrong argument number');
       NEW_Print := nil;
    end;
  end;
end;

function NEW_Output( self, args:PPyObject): PPyObject; cdecl;
var
  TempObj,StrObj : PPyObject;
  text: PChar;
begin
  with GetPytDLL(self) do begin
    if PyArg_ParseTuple(args,'O',[@TempObj]) <> 0 then begin
       StrObj := PyObject_Str(TempObj);
       text := PyString_AsString(StrObj);
       Form1.Memo2.Lines.Add(text);
       Py_XDECREF(StrObj);
       Py_INCREF(Py_None);
       NEW_Output := Py_None;
    end else begin
       PyErr_SetString(GetErrorObject(self), 'Wrong argument number');
       NEW_Output := nil;
    end;
  end;
end;

function NEW_TestIO( self, args:PPyObject): PPyObject; cdecl;
var
  i1,i2,i3: Integer;
  RetObj : PPyObject;
begin
  with GetPytDLL(self) do begin
    if PyArg_ParseTuple(args,'iii',[@i1,@i2,@i3]) <> 0 then begin
       RetObj := Py_BuildValue('(iii)',[i1+i2,i1+i3,i2+i3]);
       NEW_TestIO := RetObj;
    end else begin
       PyErr_SetString(GetErrorObject(self), 'Wrong argument number');
       NEW_TestIO := nil;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  filename := '*.py';
  with PytRun1 do begin
    addmethod('Debug',NEW_Debug,1,nil);
    addmethod('Output',NEW_Output,1,nil);
    addmethod('NEW_Print',NEW_Print,1,nil);
    addmethod('TestIO',NEW_TestIO,1,nil);
    Memo2.Lines.Add('');
    pdict := InitModule( 'DelphPyt',getmethods,'DelphPyt-Test-Version',
                         PChar(ParamStr(0)));
  end;
end;

procedure TForm1.LoadButtonClick(Sender: TObject);
begin
  if filename <> '*.py' then LoadDialog.FileName := filename;
  if LoadDialog.execute then begin
    filename := LoadDialog.FileName;
    Memo1.Lines.LoadFromFile(filename);
  end;
end;

procedure TForm1.SaveButtonClick(Sender: TObject);
begin
  if filename <> '*.py' then SaveDialog.FileName := filename;
  if SaveDialog.execute then begin
    filename := SaveDialog.FileName;
    Memo1.Lines.SaveToFile(filename);
  end;
end;

procedure TForm1.EvalButtonClick(Sender: TObject);
begin
  run_memo_script(eval_input);
end;

end.

