/* simple1.java  */
/* Chris Jacobi, January 23, 1997 2:46 pm PST */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: simple1.java,v 1.5 1997/01/23 22:46:24 jacobi Exp $ */

/*
 * A simple client program that demonstrates the use of the
 * Calculator module as a library.
 */ 
 
/*
 * Run this like
 * java Tutorial.simple1 number [number...]
 */ 

package Tutorial;

public class simple1 {
    
    public static void main(String argv[]) {
        CalculatorImpl calc;
        //create the calculator
        calc = new CalculatorImpl();
        if (calc==null) {
            System.err.println("Got null TapeCalculator");
            System.exit(1);
        }
        //clear the calculator before using it
        calc.SetValue(0.0);
        //now loop over the arguments, adding each in turn
        int i = 0;
        while (i<argv.length) {
            Double v = Double.valueOf(argv[i]); //don't bother about exceptions
            calc.Add(v.doubleValue());
            i = i+1; 
        } 
        //and print the result
        System.out.println("The sum is " + calc.GetValue());
    } //main
    
} //simple1
