// ServerILU.java
// Chris Jacobi, May 9, 1997 8:22 pm PDT

import java.util.*;

class Account implements Bank.Account {
  Account(float balance) {
    _balance = balance;
  }
  public float balance() throws xerox.ilu.IluSystemException {
    return _balance;
  }
  private float _balance;
}

class AccountManager implements Bank.AccountManager {
  AccountManager(String name) {
    //super(name);
  }
  public Bank.Account open(String name) throws xerox.ilu.IluSystemException {
    // Lookup the account in the account dictionary.
    Bank.Account account = (Bank.Account) _accounts.get(name);
    if(account == null) {
      // Create a new account with between 0 and 1000 dollars.
      float balance = Math.abs(_random.nextInt()) % 100000 / 100f;
      account = new Account(balance);
      System.out.println("Created " + name + "'s account: " + account);
      // Export the new object reference.
      // CORBA.ORB.init().BOA_init().obj_is_ready(account);
      // Save the account in the account dictionary.
      _accounts.put(name, account);
    }
    // Return the account.
    return account;
  }
  private Dictionary _accounts = new Hashtable();
  private Random _random = new Random();
}

public class ServerILU {
  static xerox.ilu.IluServer trueServer;
  
  public static void main(String[] args) {
    try {
      // Initialize the ORB.
      trueServer = xerox.ilu.IluServer.createServer("ThisExamplesServer");
      String[] ti = {"tcp_0_0"};
      trueServer.createPort("iiop", new xerox.ilu.IluTransportInfo(ti), null);

      // Initialize the BOA.
      // Create the account manager object.
      AccountManager manager = 
	new AccountManager("Post-Modern Bank");
      // Export the newly create object.
      Bank._allJavaStubs.load();
      Bank.AccountManagerStub.registerTrueObject( 
          "OurManager", 
          manager, 
          trueServer);
      System.out.println(xerox.ilu.Ilu.iorOfObject(manager));
      // Wait for incoming requests
    } catch(xerox.ilu.IluSystemException e) {
      System.err.println(e);
    }
  }
}

