/* TestSending.java */
/* Chris Jacobi, October 24, 1997 1:29 pm PDT */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: TestSending.java,v 1.5 1997/10/24 20:32:17 jacobi Exp $ */

package somepackage; 

/**
 * This class is the server side of a sample application of 
 * full custom mapping.
 */
class TestSending {
  
    static xerox.ilu.IluServer trueServer;
    static ObjectGetterImpl getter;
    
    static void handleOut() {
        try {
            System.out.println("Starting a server");
            trueServer = xerox.ilu.IluServer.createServer("JavaPiTeServer");
            System.out.println("Server created");
            getter = new ObjectGetterImpl();
            testJavaSerialObjects.ObjectGetterStub.registerTrueObject( 
                "myFactory", 
                getter, 
                trueServer
                );
            xerox.ilu.IluSimpleBinding.publish(getter);
            System.out.println("Factory instance published");
            String sbh = xerox.ilu.Ilu.sbhOfObject(getter);
            System.out.println("Its SBH is '" + sbh + "'");
        } catch (xerox.ilu.IluSystemException e) {
            System.err.println("Caught an ilu exception: " + e );
        }
    } //handleOut

    public static void main(String argv[]) {
        System.out.println("Start TestSending");
        xerox.javaSerialObjects._allJavaStubs.load();
        testJavaSerialObjects._allJavaStubs.load();
        System.out.println("junk is loaded");
        xerox.javaSerialObjects.ClassAccessor accessor = null;
        accessor = new xerox.javaSerialObjects.ClassAccessorImpl(
            "MyJarFile.jar"
            );
        xerox.javaSerialObjects.JavaObjectHandler.setDefaultClassAccessor(
            accessor
            );
        System.out.println("default accessor is set");
        handleOut();
    } //main

} //TestSending


class ObjectGetterImpl implements testJavaSerialObjects.ObjectGetter {
        
    public ObjectGetterImpl() {
    }
    
    static int count = 0;
    
    public java.lang.Object GetIt() 
                        throws xerox.ilu.IluSystemException {
        java.lang.Object ob = "silly string";
        System.out.println("ObjectGetterImpl called");
        count = count + 1;
        if (count==2) {return null;}
        if (count==3) ob = this;
        FooWhizBangFuzzler x = new FooWhizBangFuzzler(ob);
        return x;
    } //GetIt
    
} //ObjectGetterImpl



