# Demonstration of a sky-box (fully wrapping background)

def clipPoly(points, cpx, cpy, cpz, cpw):
	if not points: return []
	out = []
	ox, oy, oz, os, ot = points[-1]
	oldeqn = (ox*cpx)+(oy*cpy)+(oz*cpz)+cpw
	for x, y, z, s, t in points:
		neweqn = (x*cpx)+(y*cpy)+(z*cpz)+cpw
		if ((oldeqn < 0.0 < neweqn) or (neweqn < 0.0 < oldeqn)):
			odist = abs(neweqn)
			ndist = abs(oldeqn)
			sum = odist+ndist
			odist = odist / sum
			ndist = ndist / sum			
			midx = (ox * odist) + (x * ndist)
			midy = (oy * odist) + (y * ndist)
			midz = (oz * odist) + (z * ndist)
			mids = (os * odist) + (s * ndist)
			midt = (ot * odist) + (t * ndist)
			out.append([midx, midy, midz, mids, midt])
		if neweqn > 0.0:
			out.append([x, y, z, s, t])
		ox, oy, oz, os, ot = x, y, z, s, t
		oldeqn = neweqn
	return out

def crossProduct((x1, y1, z1), (x2, y2, z2)):
	return (y1*z2-z1*y2, z1*x2-x1*z2, x1*y2-y1*x2)

def main():
	# Calculate view-frustrum clipping planes
	c1 = (-1.0, -0.75, 1.0)
	c2 = ( 1.0, -0.75, 1.0)
	c3 = (-1.0,  0.75, 1.0)
	c4 = ( 1.0,  0.75, 1.0)
	cp1x, cp1y, cp1z = crossProduct(c1, c2)
	cp2x, cp2y, cp2z = crossProduct(c4, c3)
	cp3x, cp3y, cp3z = crossProduct(c3, c1)
	cp4x, cp4y, cp4z = crossProduct(c2, c4)
	cp1w = cp2w = cp3w = cp4w = 0.0
	# Last one is backplane for camera
	cp5x = cp5y = 0.0; cp5z = 1.0; cp5w = -0.1

	# Cube Points
	p1, p2, p3, p4, p5, p6, p7, p8 = (
		[-1, -1, -1], [-1, -1, 1], [-1, 1, -1], [-1, 1, 1],
		[1, -1, -1], [1, -1, 1], [1, 1, -1], [1, 1, 1])
	# texture coordinates
	TL = [1.5, 1.5]; TR = [254.5, 1.5]
	BL = [1.5, 254.5]; BR = [254.5, 254.5]
	# Sides of box
	d1 = [p2+TL, p6+TR, p8+BR, p4+BL]
	d2 = [p6+TL, p5+TR, p7+BR, p8+BL]
	d3 = [p5+TL, p1+TR, p3+BR, p7+BL]
	d4 = [p1+TL, p2+TR, p4+BR, p3+BL]
	d5 = [p1+TL, p5+TR, p6+BR, p2+BL]
	d6 = [p4+TL, p8+TR, p7+BR, p3+BL]
	# Setup GLIDE
	glide.grGlideInit()
	glide.grSstSelect(0)
	ctxt = glide.grSstWinOpen(0, glide.GR_RESOLUTION_640x480,
		glide.GR_REFRESH_60Hz,
		glide.GR_COLORFORMAT_ARGB,
		glide.GR_ORIGIN_UPPER_LEFT, 2, 0)
	if not ctxt:
		print 'No Glide Context - Cannot Run'
		return
	glide.grCoordinateSpace(glide.GR_WINDOW_COORDS)
	glide.grTexFilterMode(glide.GR_TMU0,
		glide.GR_TEXTUREFILTER_BILINEAR,
		glide.GR_TEXTUREFILTER_BILINEAR)
	glide.grTexClampMode(glide.GR_TMU0,
		glide.GR_TEXTURECLAMP_CLAMP,
		glide.GR_TEXTURECLAMP_CLAMP)
	glide.grColorCombine(glide.GR_COMBINE_FUNCTION_SCALE_OTHER,
					glide.GR_COMBINE_FACTOR_ONE,
					glide.GR_COMBINE_LOCAL_ITERATED,
					glide.GR_COMBINE_OTHER_TEXTURE, 0)
	glide.grTexCombine(glide.GR_TMU0,
		glide.GR_COMBINE_FUNCTION_LOCAL,
		glide.GR_COMBINE_FACTOR_ZERO,
		glide.GR_COMBINE_FUNCTION_LOCAL,
		glide.GR_COMBINE_FACTOR_ZERO, 0, 0)

	glide.grVertexLayout(glide.GR_PARAM_XY, 0, glide.GR_PARAM_ENABLE)
	glide.grVertexLayout(glide.GR_PARAM_Z, 2, glide.GR_PARAM_ENABLE)
	glide.grVertexLayout(glide.GR_PARAM_ST0, 3, glide.GR_PARAM_ENABLE)
	glide.grVertexLayout(glide.GR_PARAM_Q0, 5, glide.GR_PARAM_ENABLE)
	
	# Now allocate and download the textures.
	
	texpos = glide.grTexMinAddress(glide.GR_TMU0)
	texsize = glide.grTexCalcMemRequired(glide.GR_LOD_LOG2_256,
		glide.GR_LOD_LOG2_256, glide.GR_ASPECT_LOG2_1x1,
		glide.GR_TEXFMT_RGB_565)
	twomeg = 2*1024*1024
	texaddrs = [0]*6
	topAddress = glide.grTexMaxAddress(glide.GR_TMU0)
	for t in range(6):
		fh = open('frame%d.565' % (t+1), 'rb')
		# Texture cannot cross a 2Mb boundary
		if (texpos + texsize)/twomeg != (texpos/twomeg):
			texpos = (texpos - (texpos&(twomeg-1))) + twomeg
		if texpos + texsize > topAddress:
			print 'Not enough texture memory!'
			return
		fh.read(2) # ignore width/height
		data = fh.read(256 * 256 * 2)
		glide.grTexDownloadMipMap(glide.GR_TMU0, texpos,
			glide.GR_MIPMAPLEVELMASK_BOTH,
			glide.GR_LOD_LOG2_256, glide.GR_LOD_LOG2_256,
			glide.GR_ASPECT_LOG2_1x1, glide.GR_TEXFMT_RGB_565,
			data)
		texaddrs[t] = texpos
		texpos = texpos + texsize
		fh.close()
	heading = 0.0
	pitch = 0.0

	# This is the main animation loop
	while 1:
		heading = heading + 0.02
		pitch = math.sin(heading)*0.5
		#pitch = 0.00
		#glide.grBufferClear(0, 0, 0)
		sinh = math.sin(heading)
		cosh = math.cos(heading)
		sinp = math.sin(pitch)
		cosp = math.cos(pitch)
		texture = 0
		for side in [d1, d2, d3, d4, d5, d6]:
			glide.grTexSource(glide.GR_TMU0,
				texaddrs[texture],
				glide.GR_MIPMAPLEVELMASK_BOTH,
				glide.GR_LOD_LOG2_256,
				glide.GR_LOD_LOG2_256,
				glide.GR_ASPECT_LOG2_1x1,
				glide.GR_TEXFMT_RGB_565)
			texture = texture + 1
			newside = []
			# Rotate cube side
			for x, y, z, s, t in side:
				x2 = (cosh*x)+(sinh*z)
				z2 = (cosh*z)-(sinh*x)
				y2 = y
				y = (cosp*y2)+(sinp*z2)
				z = (cosp*z2)-(sinp*y2)
				x = x2
				newside.append([x, y, z, s, t])
			# Now clip it
			newside = clipPoly(newside, cp1x, cp1y, cp1z, cp1w)
			newside = clipPoly(newside, cp2x, cp2y, cp2z, cp2w)
			newside = clipPoly(newside, cp3x, cp3y, cp3z, cp3w)
			newside = clipPoly(newside, cp4x, cp4y, cp4z, cp4w)
			newside = clipPoly(newside, cp5x, cp5y, cp5z, cp5w)
			# Build the list to send to grDrawVertexArray
			drawside = []
			if len(newside) >= 3:
				for x, y, z, s, t in newside:
					drawside.append([320+(x*320.0/z), 240+(y*320.0/z), z, s/z, t/z, 1.0/z])
			glide.grDrawVertexArray(glide.GR_POLYGON, drawside)
		glide.grBufferSwap(1)

# Now run the main program

import glide, math, sys
try:
	main()
finally:
	glide.grGlideShutdown()
