"""Frames widget"""
#************************************************************************************************************
# Author:            rpd Kiss, arpadk@geometria.hu
# Modified:          1998.10.27
# Platform:          -
# Description:       Tabbed frames version 0.72
#                    This widget is static. You cannot add, remove or change a tab behaviour.
#                    If you want to catch the click event then you have to rewrite the _TabClick method, but if you
#                    change to another tab with Tabs['index']=newindex statement then you have to change the _Raise
#                    method too to catch this.
#                    You can query the init parameters, but you cannot set them(except index)
#                    You can get the current tabindex with one of these ways: Tabs['index'] or Tabs.cget(index)
#                    To activate another tab: Tabs['index']=newindex or Tabs.configure(index=newindex)
#                    To reference the ith frame: Tabs[i] 
#                    All variables/functions begining with an underscore are considered as local. Don't set them from
#                    outside of the class.
# Todos:             tabsperrow is not used at the moment. The widget always creates one line of tabs above the frames.
#                    Enabled/disabled/visible tab
#                    The selected tab should be wider & higher than the others
#                    Not selected tabcolor
#                    tabposition: top, bottom, left, right
#************************************************************************************************************



#Imports
#************************************************************************************************************
from Tkinter import *
#************************************************************************************************************



#Constants
#************************************************************************************************************
ROUNDED = 'rounded'
SQUARE  = 'square'
#************************************************************************************************************



#
#************************************************************************************************************
class Frames(Canvas):

    def __init__(self,
                 root=None,
		 captions=('first','second','third'),
		 tabsperrow=3,
		 font='helvetica 10',
		 textcolor='black',
		 background='gray80',
		 borderwidth=2,
		 relief=RAISED,
		 tabgap=0,
		 index=0,
		 tabstyle=SQUARE,
		 **kw):
	Canvas.__init__(self,root,kw)
	#
	# we have to have at least one tab
	if len(captions)==0:
	    self._captions=(' ')
	else:
	    self._captions=captions
	self._tabsperrow=tabsperrow
	self._borderwidth=borderwidth
	self._relief=relief
	self._textcolor=textcolor
	self._textfont=font
	self._bg=background
	self._tabgap=tabgap
	self._tabstyle=tabstyle
	#
	self._index=None
	self._frames=[]
	self._top,self._left=1,1
	self._right=self.winfo_width()-2
	self._bottom=self.winfo_height()-2
	self['borderwidth']=0
	#
	self._DrawMe(index)
	#
	self.bind('<ButtonPress>',self._TabClick)
	self.bind('<Configure>',self._Configure)
		       
    def __getitem__(self,i):
	if type(i)==type(1):
	    # it is an index of a frame
	    return self._frames[i]
	else:
	    # it is a Tk property
	    return self.cget(i)
		       
    def __len__(self):
	# return len(self._frames) doesn't work, because when we create the frames(these are the children of self)
	# there is an inplicit __len__ call and it would return 0, so creating frames would be failed
	return len(self._captions)
	
    def configure(self,p={},**kw):
	self._PreConfig(p,kw)
	for k,v in p.items():
	    kw[k]=v
	Canvas.configure(self,kw)
	
    def cget(self,parName):
	if parName=='captions':
	    return self._captions
	elif parName=='tabsperrow':
	    return self._tabsperrow
	elif parName=='font':
	    return self._textfont
	elif parName=='textcolor':
	    return self._textcolor
	elif parName=='background':
	    return self._bg
	elif parName=='borderwidth':
	    return self._borderwidth
	elif parName=='relief':
	    return self._relief
	elif parName=='tabgap':
	    return self._tabgap
	elif parName=='index':
	    return self._index
	elif parName=='tabstyle':
	    return self._tabstyle
	else:
	    # this is not mine, call the parent
	    return Canvas.cget(self,parName)
    
    #some properties have to been processed and  deleted, then the others are sent to Canvas
    def _PreConfig(self,p,kw):
	if kw.has_key('captions'):
	    del kw['captions']
	if p.has_key('captions'):
	    del p['captions']
	if kw.has_key('tabsperrow'):
	    del kw['tabsperrow']
	if p.has_key('tabsperrow'):
	    del p['tabsperrow']
	if kw.has_key('font'):
	    del kw['font']
	if p.has_key('font'):
	    del p['font']
	if kw.has_key('textcolor'):
	    del kw['textcolor']
	if p.has_key('textcolor'):
	    del p['textcolor']
	if kw.has_key('background'):
	    del kw['background']
	if p.has_key('background'):
	    del p['background']
	if kw.has_key('borderwidth'):
	    del kw['borderwidth']
	if p.has_key('borderwidth'):
	    del p['borderwidth']
	if kw.has_key('relief'):
	    del kw['relief']
	if p.has_key('relief'):
	    del p['relief']
	if kw.has_key('tabgap'):
	    del kw['tabgap']
	if p.has_key('tabgap'):
	    del p['tabgap']
	if kw.has_key('index'):
	    self._Raise(kw['index'])
	    del kw['index']
	if p.has_key('index'):
	    self._Raise(p['index'])
	    del p['index']
	if kw.has_key('tabstyle'):
	    del kw['tabstyle']
	if p.has_key('tabstyle'):
	    del p['tabstyle']
	
    def _TabClick(self,event):
	self.focus_set()
	ids=self.find_withtag(CURRENT)
	if len(ids)>0:
	    ItemID=ids[0]
	    tags=self.gettags(ItemID)
	    if tags[0][:3]=='tab':
		self._Raise(int(tags[0][3:]))

    def _Configure(self,event):
	self._right=self.winfo_width()-2
	self._bottom=self.winfo_height()-2
	self._ResizeFrames()
	self._DrawFrameBorder()
	self._Raise(self._index)
	
    def _Raise(self,ind):
	if self._index!=None:
	    self.lower('tab'+str(self._index),ALL)
	    self.itemconfigure('text'+str(self._index),font=self._textfont)
	self._index=ind
	self._frames[self._index].tkraise()
	self.tkraise('tab'+str(self._index),ALL)
	self.itemconfigure('text'+str(self._index),font=self._textfont+' bold')
	
    def _DrawMe(self,index):
	# creating tabs
	self._DrawTabs()
	#creating frames
	self._frames=[]
	for itab in range(len(self._captions)):
	    frm=Frame(self,bg=self._bg,borderwidth=0)
	    self._frames.append(frm)
	self._ResizeFrames()
	#creating the border of the frames
	self._DrawFrameBorder()
	#raising the current tab
	self._Raise(index)

    def _DrawTabs(self):
	ileft=self._left
	itop=self._top
	for itab in range(len(self._captions)):
	    textID=self.create_text(ileft+self._borderwidth,itop+self._borderwidth,text='   '+self._captions[itab]+'   ',font=self._textfont,fill=self._textcolor,anchor=NW,tags=('tab'+str(itab),'frame'+str(itab),'text'+str(itab)))
	    x1,y1,x2,y2=self.bbox(textID)
	    self.move(textID,ileft+self._borderwidth-x1,itop+self._borderwidth-y1)
	    x1,y1,x2,y2=ileft+self._borderwidth,itop+self._borderwidth,x2+ileft+self._borderwidth-x1+1,y2+itop+self._borderwidth-y1+1
	    polID=self.create_polygon(x1+1,y1+1,x2-1,y1+1,x2-1,y2+self._borderwidth-1,x1+1,y2+self._borderwidth-1,tags=('tab'+str(itab),'frame'+str(itab),'poly'+str(itab)),fill=self._bg,outline=self._bg)
	    self.tkraise(textID,polID)
	    for i in range(self._borderwidth):
		tlc,brc=self._GetColors(i)
		if self._tabstyle==ROUNDED:
		    self.create_line(x1+1+i,y1-self._borderwidth+1+i,x2-1-i,y1-self._borderwidth+1+i,fill=tlc,tags=('tab'+str(itab),'frame'+str(itab)))
		    self.create_line(x1-self._borderwidth+1+i,y1+1+i,x1-self._borderwidth+1+i,y2+i,fill=tlc,tags=('tab'+str(itab),'frame'+str(itab)))
		    self.create_line(x2+self._borderwidth-1-i,y1+1+i,x2+self._borderwidth-1-i,y2+i,fill=brc,tags=('tab'+str(itab),'frame'+str(itab)))
		    self.create_line(x1+1+i,y1-self._borderwidth+1+i,x1-self._borderwidth+1+i,y1+1+i,fill=tlc,tags=('tab'+str(itab),'frame'+str(itab)))
		    self.create_line(x2-1-i,y1-self._borderwidth+1+i,x2+self._borderwidth-1-i,y1+1+i,fill=brc,tags=('tab'+str(itab),'frame'+str(itab)))
		else:
		    # SQUARE otherwise
		    self.create_line(x1-self._borderwidth+1+i,y1-self._borderwidth+1+i,x2+self._borderwidth-1-i,y1-self._borderwidth+1+i,fill=tlc,tags=('tab'+str(itab),'frame'+str(itab)))
		    self.create_line(x1-self._borderwidth+1+i,y1-self._borderwidth+1+i,x1-self._borderwidth+1+i,y2+i,fill=tlc,tags=('tab'+str(itab),'frame'+str(itab)))
		    self.create_line(x2+self._borderwidth-1-i,y1-self._borderwidth+1+i,x2+self._borderwidth-1-i,y2+i,fill=brc,tags=('tab'+str(itab),'frame'+str(itab)))
	    ileft=x2+self._tabgap+self._borderwidth-1
	self._tabstripheight=y2-self._top-1+self._borderwidth
	
    def _DrawFrameBorder(self):
	self.delete('frameborder')
	ftop=self._top+self._tabstripheight-self._borderwidth+1
	for i in range(self._borderwidth):
	    tlc,brc=self._GetColors(i)
	    self.create_line(self._left+1+i,ftop+i,self._right-1-i,ftop+i,fill=tlc,tags=('frameborder',))
	    self.create_line(self._left+1+i,ftop+i,self._left+1+i,self._bottom-1-i,fill=tlc,tags=('frameborder',))
	    self.create_line(self._right-1-i,ftop+i,self._right-1-i,self._bottom-1-i,fill=brc,tags=('frameborder',))
	    self.create_line(self._right-1-i,self._bottom-1-i,self._left+1+i,self._bottom-1-i,fill=brc,tags=('frameborder',))

    # it returns (top-left color,bottom-right color) for ith line
    def _GetColors(self,i):
	if self._relief==FLAT:
	    if i==0:
		return ('gray90','gray35')
	    elif i==self._borderwidth-1:
		return ('gray35','gray90')
	    else:
		return ('gray55','gray55')
	elif self._relief==SOLID:
	    return ('gray55','gray55')
	elif self._relief==RAISED:
	    return ('gray90','gray55')
	elif self._relief==SUNKEN:
	    return ('gray55','gray90')
	elif self._relief==RIDGE:
	    if i+1<=float(self._borderwidth)/2:
		return ('gray90','gray55')
	    else:
		return ('gray55','gray90')
	elif self._relief==GROOVE:
	    if i+1<=float(self._borderwidth)/2:
		return ('gray55','gray90')
	    else:
		return ('gray90','gray55')
	else:
	    return ('gray90','gray55')
    
    def _ResizeFrames(self):
	for ifrm in self._frames:
	    ifrm.place(x=self._left+self._borderwidth+1,
	               y=self._top+self._tabstripheight+1,
		       width=self._right-self._left-2*self._borderwidth-1,
		       height=self._bottom-self._top-self._borderwidth-self._tabstripheight-1,
		       anchor=NW)
#************************************************************************************************************



#Test
#************************************************************************************************************
if __name__=='__main__':
    root=Tk()
    tbs=Frames(root,captions=('FIRST','SECOND','THIRD'),relief=RIDGE,borderwidth=4,tabgap=1,background='lightblue',textcolor='indianred',font='times 12',tabstyle=ROUNDED)
    #creating some controls on the tabs
    e=Entry(tbs[1])
    e.insert(0,'Sample entry box')
    e.pack(side=RIGHT)
    for i in range(len(tbs)):
	Label(tbs[i],text=str(i+1)+'. tab').pack(side=LEFT)
    tbs.pack(fill=BOTH,expand=YES)
    tbs['index']=2
    root.mainloop()
    print tbs.cget('index'),tbs['index']
