#------------------------------------------------------------------------------
#	Anagram.py*
#
#	A Dictionary-based Anagram Maker by:
#
#                                     Andrew C. Yinger <acy@slip.net>
#
#	last revised: 11/23/98
#
#		* note: requires the file words.txt, to be used as a Dictionary
#------------------------------------------------------------------------------

import sys
import string
import whrandom

# Misc Variables and Lists

argps = sys.argv[1:]
# Test for Args
if len(sys.argv)==1:
	print '\nUsage: Anagram.py [word(s) to be parsed] \n'
	sys.exit()

argpps = 'I'
oldpos=0
Iter=raw_input(' \n How many Attempts? ')
Iter=string.atoi(Iter)
for i in range(0,len(argps)):
	argpps=argpps+argps[i]

argpps=argpps[1:]
InitLen=len(argpps)


# Create Dictionary WordDict from words in file: words.txt

fa=open('words.txt','r')
wcelist=fa.readlines()
fa.close() # close file
WordDict={'initializze':0}
for a in range(len(wcelist)):
	WordDict[wcelist[a][0:string.find(wcelist[a],' ')]]=a


# Functions

def findword(Word):
	"Find word in wscpelist, word dict from words.txt"
	if WordDict.has_key('~'+string.lower(Word)):
		# ACROnyms
		return string.upper(Word)
	elif WordDict.has_key('~~'+string.lower(Word)):
		# Abrievations
		return string.capitalize(Word)+'.'
	elif WordDict.has_key(string.lower(Word)):
		# FullWords
		return string.capitalize(Word)
	else:
		return 0

def Scramble(args):
	"Create Efficient Random String Scramble of args"
	# initialize list vars and concat'n vars
	a=32
	Newargs='i'
	rindex=['i']
	rlist=['i']

	# Create artificial symbol index (rindex) based on len(args)
	for i in range(len(args)):
		a=1+a
		rindex.append(chr(a))

	rindex=rindex[1:]

	# Randomize Character Indices in Rlist
	while len(rlist)!=len(args)+1:
		rnum = whrandom.randint(1,len(args)-(len(rlist)-1))
		rlist.append(ord(rindex[rnum-1])-32)
		rindex[rnum-1:rnum]=[] # remove index in rindex
		# print rlist, rindex # remove leading '#' for debug

	# Generate Newargs based on # slices of args from rlist
	for i in range(1,len(rlist)):
		Newargs=Newargs+args[rlist[i]-1]

	return Newargs[1:]

def CreateWord(arg,oldpos,Max):
	"Scramble Input, test random substr to see if word and return"
	for i in range(1000):
		AllScrambled=Scramble(arg)
		RandMin=(whrandom.randint(0,3))+(whrandom.randint(0,3))+(whrandom.randint(0,4))+(whrandom.randint(0,4))
		if RandMin>Max:
			RandMin=Max-1

		for a in range(Max,RandMin,-1):
			FirstWord=AllScrambled[:a]
			ExistWord=findword(FirstWord)
			if ExistWord!=0:
				oldpos=oldpos+a
				return [ExistWord, AllScrambled, oldpos]
				break
			else:
				pass


# Main Body

print '\n'

for i in range(1,Iter+1):
	for a in range((len(argpps)/3)+3):
		if a==0:
			Anagram='I'
			Mutargpps=argpps
			Length=0
		else:
			oldpos=AWords[2]-oldpos
			Mutargpps=AWords[1][oldpos:]

		AWords=CreateWord(Mutargpps,oldpos,len(Mutargpps))
		try:
			AWord=AWords[0]
		except AttributeError:		# Win32
			# except TypeError:	# (on Unix systems)
			break

		Length=len(AWord)+Length
		Anagram=Anagram+AWord+' '
		# print AWord,

	if Length!=InitLen:
		pass
		# print '\n', ' '*50+`Length`+' of '+`InitLen`+' Leftovers: '+'['+`Mutargpps`+']', '\n'
	else:
		print `i`+'.	'+Anagram[1:], '\n'
		# print '\n', '\n'


