"""
Simple plotting interface using MATLAB. This module is really meant
to be nothing more than an example of how to use the PyMat module.
A true front-end for MATLAB plotting would have many more functions,
a class-based structure for figures with properties that could be
get/set, etc.
"""

import pymat
import Numeric
import types

H = None

def openSession():
  global H
  
  if not H:
    H = pymat.open()

def closeSession():
  global H

  if H:
    pymat.close(H)
    H=None

def eval(str):
  openSession()

  pymat.eval(H, str)

def plot(x, y=None, *args):
  if not y:
    y=x
    x=Numeric.arrayrange(len(y))
  
  openSession()

  pymat.put(H, 'x__', x)
  pymat.put(H, 'y__', y)

  s = 'plot(x__,y__'
  for item in args:
    s = s + "," + repr(item)
  s = s + ')'

  pymat.eval(H, s)

def hold(onoff):
  openSession()

  if onoff:
    s = 'hold on'
  else:
    s = 'hold off'

  pymat.eval(H, s)

def subplot(rows,cols,index):
  openSession()

  s = 'subplot(%d,%d,%d)' % (rows,cols,index)
  pymat.eval(H, s)

def close():
  openSession()

  pymat.eval(H, 'close')

def newfigure():
  openSession()

  pymat.eval(H, 'figure')

def figurenum():
  openSession()

  pymat.eval(H, "h__=get(0,'CurrentFigure')")
  h = pymat.get(H, 'h__')
  if len(h):
    return h[0]
  else:
    return None

def title(s, *args):
  openSession()

  s = s % args
  pymat.eval(H, "title('%s')" % s)

def xlabel(s, *args):
  openSession()

  s = s % args
  pymat.eval(H, "xlabel('%s')" % s)

def ylabel(s, *args):
  openSession()

  s = s % args
  pymat.eval(H, "ylabel('%s')" % s)

def axis(val=None):
  openSession()

  if not val:
    pymat.eval(H, 'h__ = axis')
    return pymat.get(H, 'h__')

  if type(val) == types.StringType:
    pymat.eval(H,"axis('%s')" % val)
    return

  pymat.put(H, 'h__', val)
  pymat.eval(H, 'axis(h__)')
  return

def text(x, y, z, s=None):
  openSession()

  if not s:
    s = z
    z = None

  if z:
    pymat.eval(H, "text(%g,%g,%g,'%s')" % (x,y,z,s))
  else:
    pymat.eval(H, "text(%g,%g,'%s')" % (x,y,s))
  return

