"""
Author:  	Arpad Kiss, sekter@mail.matav.hu 
Modified:       1999.06.21.
Platform:	- 
Description:	Extra widgets version 0.48
Widgets:	StringEntry, IntegerEntry, FloatEntry, DateEntry, CheckBox 
		Most of them have the next cget parameters: value,mandatory,value_error_details
  		and
		the next configure parameters: value, mandatory, validate_function 
		All variables/functions begining with an underscore are considered as
		local. Don't set them from outside of the class.  
Todos:  	Upper case and lower case conversion for accented characters doesn't work. 
		length is not checked 
		HintText would be nice
"""



#Imports
#************************************************************************************************************
from Tkinter     import *
from Tkinter import _cnfmerge
import string
import re
#************************************************************************************************************



#Constants
#************************************************************************************************************
#************************************************************************************************************



#This is the base textbox
#************************************************************************************************************
class StringEntry(Entry):
    
    _defregexpobj=None
    _error_messages=((0,0,'This field is mandatory!'),
	             (0,1,"Invalid format!"),
	             (0,2,"The value is less than the minimum!"),
	             (0,3,"The value is greater than the maximum!")) #((0,error number,error text),..); the first number is 1 if this message come from self._validate_function
    
    # state_args=(dict of enabled args, dict of disabled args,dict of valueerror args)
    def __init__(self,parent=None,state_args=({'bg':'green'},{'bg':'blue'},{'bg':'red'}),**kw):
	self._value=StringVar()
	self._mandatory=NO
	self._validate_function= lambda value: TRUE
	self._value_error_description=None
	# these are for intervallum validation:
	self._minimum=None
	self._maximum=None
	# compiled regular expression object
	# if it is not None then it is used at validation 
	self._regexpobj=self._defregexpobj
	self._value_error=NO
	self._enabled_args,self._disabled_args,self._error_args=state_args
	self._PreConfig(kw)
	Entry.__init__(self,parent,kw)
	self._SetState()
	self['textvariable']=self._value
	self.bind("<FocusOut>", self._FocusOut)
	
    def configure(self,cnf={},**kw):
	if kw:
		kw = _cnfmerge((cnf,kw))
	else:
		kw=_cnfmerge(cnf)
	self._PreConfig(kw)
	# if we come from self._SetState then we have to delete the 'From_SetState' key
	# and after configuring the Entry we have to call the self._SetState if 'state' is a key in kw/p, this occurs
	# when you set the 'state' property outside of this class(and we have to aply the state_args)
	From_SetState=FALSE
	if kw.has_key('From_SetState'):
	    del kw['From_SetState']
	    From_SetState=TRUE
	Entry.configure(self,kw)
	if not From_SetState and kw.has_key('state') : self._SetState()

    #the value,mandatory, minimum, maximum, regexpobj, validate_function attributes have 
    #to be processed and deleted, 
    #then the others are sent to Entry 	
    def _PreConfig(self,kw):
	if kw.has_key('value'):
	    try:
		try:
		    	self._value.set(self._ValueToString(kw['value']))
		except:
			self._value_error_description=self._error_messages[1]
	    finally:
		del kw['value']
	if kw.has_key('mandatory'):
	    self._mandatory=kw['mandatory']
	    del kw['mandatory']
	if kw.has_key('validate_function'):
	    self._validate_function=kw['validate_function']
	    del kw['validate_function']
	if kw.has_key('minimum'):
	    self._minimum=kw['minimum']
	    del kw['minimum']
	if kw.has_key('maximum'):
	    self._maximum=kw['maximum']
	    del kw['maximum']
	if kw.has_key('regexpobj'):
	    self._regexpobj=kw['regexpobj']
	    del kw['regexpobj']
	
    def cget(self,parKey):
	if parKey=='value':
	    if len(string.strip(str(self._value.get())))==0:
		return None
	    else:
		return self._StringToValue(self._value.get())
	else:
		try:
			return eval('self._'+parKey)
		except:
			return Entry.cget(self,parKey)

    __getitem__=cget
 
    def _FocusOut(self, event=None):
	self.Validate()

    def _SetState(self):
	if self['state'] == NORMAL:
	    if self._value_error_description!=None:
		kw=self._error_args
	    else:
		kw=self._enabled_args
	else:
	    kw=self._disabled_args
	#in self.configure we check the existence of 'From_SetState' key
	# without it the self.configure(kw) may cause an infinitive recursion
	kw['From_SetState']=TRUE
	self.configure(kw)
	
    def Validate(self):
	try:
	    if self._mandatory and len(string.strip(self.get()))==0:
		raise ValueError,self._error_messages[0]
	    elif len(string.strip(self.get()))!=0:
		self._CheckMinMax
		if self._regexpobj!=None:
		    if not self._regexpobj.match(string.strip(self.get())):
			raise ValueError,self._error_messages[1]
		    self._validate_function(string.strip(self.get()))
		    self._value_error_description=None
		    self._SetState()
		    return TRUE
	except ValueError,instance:
	    self._value_error_description=instance
	    self._SetState()
	    return FALSE
    
    # in inherited classes these will be overwritten:
    
    # it is called from Validate
    def _CheckMinMax(self):
	if self._minimum!=None:
		if string.strip(self.get())<self._minimum:
			raise ValueError,self._error_messages[2]
	if self._maximum!=None:
	    	if string.strip(self.get())>self._maximum:
		        raise ValueError,self._error_messages[3]
	    
    # it is called from cget
    def _StringToValue(self,parStr): return parStr
	    
    # it is called from _PreConfig
    def _ValueToString(self,parValue): return parValue
    
#************************************************************************************************************
    


#************************************************************************************************************
class IntegerEntry(StringEntry):

    _defregexpobj=re.compile('(?P<sign>[\+|\-|\b]?)\d+')

    # it is called from Validate
    def _CheckMinMax(self):
	if self._minimum!=None:
		if int(string.strip(self.get()))<self._minimum:
			raise ValueError,self._error_messages[2]
	if self._maximum!=None:
	    	if int(string.strip(self.get()))>self._maximum:
			raise ValueError,self._error_messages[3]
	    
    # it is called from cget
    def _StringToValue(self,parStr): return int(parStr)
	    
    # it is called from _PreConfig
    def _ValueToString(self,parValue): return str(parValue)

#************************************************************************************************************



#************************************************************************************************************
class FloatEntry(StringEntry):

    _defregexpobj=re.compile('(?P<sign>[\+|\-]?)(?P<man>[\d+\.\d*|\d*\.\d+|\d+])(?P<exp>[e[\+|\-]?\d+|\b])')

    # it is called from Validate
    def _CheckMinMax(self):
	if self._minimum!=None:
		if float(string.strip(self.get()))<self._minimum:
			raise ValueError,self._error_messages[2]
	if self._maximum!=None:
		if float(string.strip(self.get()))>self._maximum:
			raise ValueError,self._error_messages[3]
	    
    # it is called from cget
    def _StringToValue(self,parStr): return float(parStr)
	    
    # it is called from _PreConfig
    def _ValueToString(self,parValue): return str(parValue)

#************************************************************************************************************



#************************************************************************************************************
class DateEntry(StringEntry):

    _defregexpobj=re.compile('(?P<year>\d{1,4})\.(?P<month>\d{1,2})\.(?P<day>\d{1,2})\.') # Hungarian date format
    _error_messages=((0,0,'This field is mandatory!'),
	             (0,1,"Invalid format!"),
	             (0,2,"The value is less than the minimum!"),
	             (0,3,"The value is greater than the maximum!"),
	             (0,4,"Wrong date!")) #((0,error number,error text),..); the first number is 1 if this message come from self._validate_function
	
    def Validate(self):
	try:
	    if self._mandatory and len(string.strip(self.get()))==0:
		raise ValueError,self._error_messages[0]
	    elif len(string.strip(self.get()))!=0:
		self._CheckMinMax
		if self._regexpobj!=None:
		    result=self._regexpobj.match(string.strip(self.get()))
		    if not result:
			raise ValueError,self._error_messages[1]
		    y=int(result.group('year'))
		    m=int(result.group('month'))
		    d=int(result.group('day'))
		    self._ValidateDate(y,m,d)
		self._validate_function(string.strip(self.get()))
		self._value_error_description=None
		self._SetState()
		return TRUE
	except ValueError,instance:
	    self._value_error_description=instance
	    self._SetState()
	    return FALSE

    # it is called from Validate
    def _CheckMinMax(self):
	result=self._regexpobj.match(self._value.get())
	if result:
	    y=int(result.group('year'))
	    m=int(result.group('month'))
	    d=int(result.group('day'))
	    if self._minimum!=None:
		if y<self._minimum(0):
		    raise ValueError,self._error_messages[2]
		if y==self._minimum(0):
		    if m<self._minimum(1):
			raise ValueError,self._error_messages[2]
		    if m==self._minimum(1):
			if d<self._minimum(2):
			    raise ValueError,self._error_messages[2]
	    if self._maximum!=None:
		if y>self._maximum(0):
		    raise ValueError,self._error_messages[3]
		if y==self._maximum(0):
		    if m>self._maximum(1):
			raise ValueError,self._error_messages[3]
		    if m==self._maximum(1):
			if d>self._maximum(2):
			    raise ValueError,self._error_messages[3]
	else:
	    raise ValueError,self._error_messages[1]
	    
    # it is called from cget
    def _StringToValue(self,parStr):
	result=self._regexpobj.match(self._value.get())
	if result:
	    y=int(result.group('year'))
	    m=int(result.group('month'))
	    d=int(result.group('day'))
	    return (y,m,d)
	else:
	    return None
	    
    # it is called from _PreConfig
    def _ValueToString(self,parValue): 
	return str(parValue[0]) + '.' + str(parValue[1]) + '.' + str(parValue[2]) + '.'

    def _ValidateDate(self,parYear,parMonth,parDay):
	if parMonth<1 or parMonth>12: raise ValueError,self._error_messages[4]
	if parDay<1 or parDay>31: raise ValueError,self._error_messages[4]
	if parMonth in [2,4,6,9,11] and parDay>30: raise ValueError,self._error_messages[4]
	if parMonth==2:
	    if parDay>29: raise ValueError,self._error_messages[4]
	    if parDay==29:
		#leap year?
		if (parYear % 4)==0:
		    	if (parYear % 400)==0: raise ValueError,self._error_messages[4]
		else: 
			raise ValueError,self._error_messages[4]
	    
#************************************************************************************************************



#************************************************************************************************************
class CheckBox(Checkbutton):

    _error_messages=((0,0,'This field is mandatory!'),
	             ) #((0,error number,error text),..); the first number is 1 if this message come from self._validate_function

    def __init__(self,parent=None,state_args=({'bg':'green'},{'bg':'blue'},{'bg':'red'}),**kw):
	self._value=BooleanVar()
	self._validate_function=lambda value: TRUE
	self._value_error_description=None
	self._enabled_args,self._disabled_args,self._error_args=state_args
	self._PreConfig(kw)
	Checkbutton.__init__(self,parent,kw)
	self['variable']=self._value
	self._SetState()
        self.bind("<FocusOut>", self._FocusOut)
	
    def configure(self,cnf={},**kw):
	#preprocessing the class specific properties
	if kw:
		kw = _cnfmerge((cnf,kw))
	else:
		kw=_cnfmerge(cnf)
	self._PreConfig(kw)
	# if we come from self._SetState then we have to delete the 'From_SetState' key
	# and after configuring the self._ent we have to call the self._SetState if 'state' is a key in kw/p, this occurs
	# when you set the 'state' property outside of this class(and we have to aply the state_args)
	From_SetState=FALSE
	if kw.has_key('From_SetState'):
	    del kw['From_SetState']
	    From_SetState=TRUE
	Checkbutton.configure(self,kw)
	if not From_SetState and kw.has_key('state') : self._SetState()
	
    #the value attribute has to be processed and deleted, then the others are sent to Entry 	
    def _PreConfig(self,kw):
	if kw.has_key('value'):
	    try:
		try:
		    	self._value.set(kw['value'])
		except:
			self._value_error_description=self.__error_messages[1]
	    finally:
		del kw['value']
	if kw.has_key('validate_function'):
	    self._validate_function=kw['validate_function']
	    del kw['validate_function']

    def cget(self,parKey):
	if parKey=='value':
	    return self._value.get()
	elif parKey=='value_error':
	    return self._value_error_description!=None
	else:
	    try:
		    return eval('self._'+parKey)
	    except:
		    return Checkbutton.cget(self,parKey)

    __getitem__=cget
	
    def _FocusOut(self, event=None):
	self.Validate()

    def _SetState(self):
	if self['state'] == NORMAL:
	    if self._value_error_description!=None:
		kw=self._error_args
	    else:
		kw=self._enabled_args
	else:
	    kw=self._disabled_args
	#in self.configure we check the existence of 'From_SetState' key
	# without it the self.configure(kw) may cause an infinitive recursion
	kw['From_SetState']=TRUE
	self.configure(kw)
	
    def Validate(self):
	try:
		self._validate_function(self._value.get())
		self._value_error_description=None
	    	self._SetState()
	    	return TRUE
	except ValueError,instance:
		self._value_error_description=instance
		self._SetState()
	    	return FALSE
#************************************************************************************************************



#Test
#************************************************************************************************************
def test():

    root=Tk()
    
    ent=StringEntry(root,({'bg':'green'},{'bg':'blue'},{'bg':'red'}))
    ent.pack(fill=BOTH,expand=YES)
    ent.configure(value='This is a StringEntry')
    
    chk=CheckBox(root,({'bg':'green'},{'bg':'blue'},{'bg':'red'}))
    chk.pack(fill=BOTH,expand=YES)
    chk.configure(fg='yellow',value=1,bg='purple')
    
    # it is a sample validation function used with IntegerEntry
    def ValidateFunc(value):
	if int(value)<10:
	    raise ValueError,(0,4,"The value is less than 10!")
    
    tint=IntegerEntry(root,({'bg':'green'},{'bg':'blue'},{'bg':'red'}),validate_function=ValidateFunc)
    tint.pack(fill=BOTH,expand=YES)
    tint.configure(value=' ',mandatory=YES)
    
    de=DateEntry(root,({'bg':'green'},{'bg':'blue'},{'bg':'red'}))
    de.pack(fill=BOTH,expand=YES)
    de.configure(value=(1965,2,18))
    
    root.mainloop()
    
    print 'StringEntry value:',ent['value']
    print 'CheckBox value:',chk['value']
    print 'IntegerEntry value:',tint['value']
    print 'DateEntry value:',de['value']
    

if __name__=='__main__':
	test()
	
